@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxTokens Maximum number of tokens to include in a chunk.
 * @property overlapPercentage Percentage of overlap between adjacent chunks of a data source.
 */
public data class
AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs(
    public val maxTokens: Output<Int>,
    public val overlapPercentage: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs.builder()
            .maxTokens(maxTokens.applyValue({ args0 -> args0 }))
            .overlapPercentage(overlapPercentage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs].
 */
@PulumiTagMarker
public class
AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgsBuilder
internal constructor() {
    private var maxTokens: Output<Int>? = null

    private var overlapPercentage: Output<Int>? = null

    /**
     * @param value Maximum number of tokens to include in a chunk.
     */
    @JvmName("iatinexuoraypwis")
    public suspend fun maxTokens(`value`: Output<Int>) {
        this.maxTokens = value
    }

    /**
     * @param value Percentage of overlap between adjacent chunks of a data source.
     */
    @JvmName("ywaukqfebiprcvna")
    public suspend fun overlapPercentage(`value`: Output<Int>) {
        this.overlapPercentage = value
    }

    /**
     * @param value Maximum number of tokens to include in a chunk.
     */
    @JvmName("fmelffhscoklyemy")
    public suspend fun maxTokens(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxTokens = mapped
    }

    /**
     * @param value Percentage of overlap between adjacent chunks of a data source.
     */
    @JvmName("hrnnearyquioehlc")
    public suspend fun overlapPercentage(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overlapPercentage = mapped
    }

    internal fun build(): AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs =
        AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfigurationArgs(
            maxTokens = maxTokens ?: throw PulumiNullFieldException("maxTokens"),
            overlapPercentage = overlapPercentage ?: throw PulumiNullFieldException("overlapPercentage"),
        )
}
