@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property type Type of data that the data source is converted into for the knowledge base. Valid Values: `VECTOR`.
 * @property vectorKnowledgeBaseConfiguration Details about the embeddings model that'sused to convert the data source. See `vector_knowledge_base_configuration` block for details.
 */
public data class AgentKnowledgeBaseKnowledgeBaseConfigurationArgs(
    public val type: Output<String>,
    public val vectorKnowledgeBaseConfiguration: Output<AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .vectorKnowledgeBaseConfiguration(
                vectorKnowledgeBaseConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [AgentKnowledgeBaseKnowledgeBaseConfigurationArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseKnowledgeBaseConfigurationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var vectorKnowledgeBaseConfiguration:
        Output<AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs>? =
        null

    /**
     * @param value Type of data that the data source is converted into for the knowledge base. Valid Values: `VECTOR`.
     */
    @JvmName("xgxwhseqwrevqanb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Details about the embeddings model that'sused to convert the data source. See `vector_knowledge_base_configuration` block for details.
     */
    @JvmName("okyqubbmyfuicdnk")
    public suspend fun vectorKnowledgeBaseConfiguration(`value`: Output<AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs>) {
        this.vectorKnowledgeBaseConfiguration = value
    }

    /**
     * @param value Type of data that the data source is converted into for the knowledge base. Valid Values: `VECTOR`.
     */
    @JvmName("kjlvhaoxyvhbixqo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Details about the embeddings model that'sused to convert the data source. See `vector_knowledge_base_configuration` block for details.
     */
    @JvmName("dqatkskikpbcxtut")
    public suspend fun vectorKnowledgeBaseConfiguration(`value`: AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vectorKnowledgeBaseConfiguration = mapped
    }

    /**
     * @param argument Details about the embeddings model that'sused to convert the data source. See `vector_knowledge_base_configuration` block for details.
     */
    @JvmName("baectnstvdlkeqvb")
    public suspend fun vectorKnowledgeBaseConfiguration(argument: suspend AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vectorKnowledgeBaseConfiguration = mapped
    }

    internal fun build(): AgentKnowledgeBaseKnowledgeBaseConfigurationArgs =
        AgentKnowledgeBaseKnowledgeBaseConfigurationArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration,
        )
}
