@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property embeddingModelArn ARN of the model used to create vector embeddings for the knowledge base.
 */
public data class AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs(
    public val embeddingModelArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs.builder()
            .embeddingModelArn(embeddingModelArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgsBuilder
internal constructor() {
    private var embeddingModelArn: Output<String>? = null

    /**
     * @param value ARN of the model used to create vector embeddings for the knowledge base.
     */
    @JvmName("uovmkcfdroaicxgx")
    public suspend fun embeddingModelArn(`value`: Output<String>) {
        this.embeddingModelArn = value
    }

    /**
     * @param value ARN of the model used to create vector embeddings for the knowledge base.
     */
    @JvmName("ufvkxfwegjkbjnes")
    public suspend fun embeddingModelArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.embeddingModelArn = mapped
    }

    internal fun build(): AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs =
        AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfigurationArgs(
            embeddingModelArn = embeddingModelArn ?: throw PulumiNullFieldException("embeddingModelArn"),
        )
}
