@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property collectionArn ARN of the OpenSearch Service vector store.
 * @property fieldMapping The names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property vectorIndexName Name of the vector store.
 */
public data class AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs(
    public val collectionArn: Output<String>,
    public val fieldMapping: Output<AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs>? =
        null,
    public val vectorIndexName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs.builder()
            .collectionArn(collectionArn.applyValue({ args0 -> args0 }))
            .fieldMapping(fieldMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vectorIndexName(vectorIndexName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgsBuilder
internal constructor() {
    private var collectionArn: Output<String>? = null

    private var fieldMapping:
        Output<AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs>? =
        null

    private var vectorIndexName: Output<String>? = null

    /**
     * @param value ARN of the OpenSearch Service vector store.
     */
    @JvmName("vkqagircsemrucfd")
    public suspend fun collectionArn(`value`: Output<String>) {
        this.collectionArn = value
    }

    /**
     * @param value The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("vhiljbwfxmmdvxhy")
    public suspend fun fieldMapping(`value`: Output<AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs>) {
        this.fieldMapping = value
    }

    /**
     * @param value Name of the vector store.
     */
    @JvmName("vblgresefslcijut")
    public suspend fun vectorIndexName(`value`: Output<String>) {
        this.vectorIndexName = value
    }

    /**
     * @param value ARN of the OpenSearch Service vector store.
     */
    @JvmName("uktcbxbnaekqfony")
    public suspend fun collectionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionArn = mapped
    }

    /**
     * @param value The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("dpmpnidqecqectjp")
    public suspend fun fieldMapping(`value`: AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldMapping = mapped
    }

    /**
     * @param argument The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("lkdmgedfaknddana")
    public suspend fun fieldMapping(argument: suspend AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMappingArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldMapping = mapped
    }

    /**
     * @param value Name of the vector store.
     */
    @JvmName("jlrmxhtwsbuwnocj")
    public suspend fun vectorIndexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vectorIndexName = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs = AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationArgs(
        collectionArn = collectionArn ?: throw PulumiNullFieldException("collectionArn"),
        fieldMapping = fieldMapping,
        vectorIndexName = vectorIndexName ?: throw PulumiNullFieldException("vectorIndexName"),
    )
}
