@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property connectionString Endpoint URL for your index management page.
 * @property credentialsSecretArn ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
 * @property fieldMapping The names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property namespace Namespace to be used to write new data to your database.
 */
public data class AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs(
    public val connectionString: Output<String>,
    public val credentialsSecretArn: Output<String>,
    public val fieldMapping: Output<AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs>? = null,
    public val namespace: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs.builder()
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .credentialsSecretArn(credentialsSecretArn.applyValue({ args0 -> args0 }))
            .fieldMapping(fieldMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    private var credentialsSecretArn: Output<String>? = null

    private var fieldMapping:
        Output<AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Endpoint URL for your index management page.
     */
    @JvmName("fmmnkvgeiwxobxiv")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
     */
    @JvmName("hithephnpxxtxxcr")
    public suspend fun credentialsSecretArn(`value`: Output<String>) {
        this.credentialsSecretArn = value
    }

    /**
     * @param value The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("pjwkueswmtkudhrl")
    public suspend fun fieldMapping(`value`: Output<AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs>) {
        this.fieldMapping = value
    }

    /**
     * @param value Namespace to be used to write new data to your database.
     */
    @JvmName("wcktpxablgwwokkj")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Endpoint URL for your index management page.
     */
    @JvmName("hershgfcsspofwyl")
    public suspend fun connectionString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
     */
    @JvmName("nlpxhulkxuaonhcq")
    public suspend fun credentialsSecretArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsSecretArn = mapped
    }

    /**
     * @param value The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("ebtndadedibtdvmc")
    public suspend fun fieldMapping(`value`: AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldMapping = mapped
    }

    /**
     * @param argument The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("nnsqujtqgsosfbwr")
    public suspend fun fieldMapping(argument: suspend AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldMapping = mapped
    }

    /**
     * @param value Namespace to be used to write new data to your database.
     */
    @JvmName("oevqjjmdulishplp")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs =
        AgentKnowledgeBaseStorageConfigurationPineconeConfigurationArgs(
            connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
            credentialsSecretArn = credentialsSecretArn ?: throw
                PulumiNullFieldException("credentialsSecretArn"),
            fieldMapping = fieldMapping,
            namespace = namespace,
        )
}
