@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataField Name of the field in which Amazon Bedrock stores metadata about the vector store.
 * @property textField Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
 */
public data class AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs(
    public val metadataField: Output<String>? = null,
    public val textField: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs.builder()
            .metadataField(metadataField?.applyValue({ args0 -> args0 }))
            .textField(textField?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgsBuilder
internal constructor() {
    private var metadataField: Output<String>? = null

    private var textField: Output<String>? = null

    /**
     * @param value Name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    @JvmName("oeokkfpbksvlkkak")
    public suspend fun metadataField(`value`: Output<String>) {
        this.metadataField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
     */
    @JvmName("rcoqcfnmpwwykvpx")
    public suspend fun textField(`value`: Output<String>) {
        this.textField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    @JvmName("rixhovxswnqnyris")
    public suspend fun metadataField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataField = mapped
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
     */
    @JvmName("rtvsfynlhniakiot")
    public suspend fun textField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.textField = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs = AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMappingArgs(
        metadataField = metadataField,
        textField = textField,
    )
}
