@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property credentialsSecretArn ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
 * @property databaseName Name of your Amazon RDS database.
 * @property fieldMapping Names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property resourceArn ARN of the vector store.
 * @property tableName Name of the table in the database.
 */
public data class AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs(
    public val credentialsSecretArn: Output<String>,
    public val databaseName: Output<String>,
    public val fieldMapping: Output<AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs>? = null,
    public val resourceArn: Output<String>,
    public val tableName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs.builder()
            .credentialsSecretArn(credentialsSecretArn.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .fieldMapping(fieldMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceArn(resourceArn.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgsBuilder internal constructor() {
    private var credentialsSecretArn: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var fieldMapping:
        Output<AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs>? = null

    private var resourceArn: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
     */
    @JvmName("faixtnpxgtlndjwp")
    public suspend fun credentialsSecretArn(`value`: Output<String>) {
        this.credentialsSecretArn = value
    }

    /**
     * @param value Name of your Amazon RDS database.
     */
    @JvmName("ydcrcvvylifgibim")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("lrajhjqxgqjcwxgy")
    public suspend fun fieldMapping(`value`: Output<AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs>) {
        this.fieldMapping = value
    }

    /**
     * @param value ARN of the vector store.
     */
    @JvmName("igprgqjctvjtbmwm")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value Name of the table in the database.
     */
    @JvmName("ojxbelgdjjgydsho")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
     */
    @JvmName("aehxqsebspvvqdgf")
    public suspend fun credentialsSecretArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsSecretArn = mapped
    }

    /**
     * @param value Name of your Amazon RDS database.
     */
    @JvmName("mltttesfvcqwoguu")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("dsirggqqmaypfgvi")
    public suspend fun fieldMapping(`value`: AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldMapping = mapped
    }

    /**
     * @param argument Names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("mgioivrfruiaifoj")
    public suspend fun fieldMapping(argument: suspend AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldMapping = mapped
    }

    /**
     * @param value ARN of the vector store.
     */
    @JvmName("ypyhecluhqdhrkem")
    public suspend fun resourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value Name of the table in the database.
     */
    @JvmName("yildslevlsoydyvj")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs =
        AgentKnowledgeBaseStorageConfigurationRdsConfigurationArgs(
            credentialsSecretArn = credentialsSecretArn ?: throw
                PulumiNullFieldException("credentialsSecretArn"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            fieldMapping = fieldMapping,
            resourceArn = resourceArn ?: throw PulumiNullFieldException("resourceArn"),
            tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        )
}
