@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataField Name of the field in which Amazon Bedrock stores metadata about the vector store.
 * @property primaryKeyField Name of the field in which Amazon Bedrock stores the ID for each entry.
 * @property textField Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
 * @property vectorField Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
 */
public data class AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs(
    public val metadataField: Output<String>,
    public val primaryKeyField: Output<String>,
    public val textField: Output<String>,
    public val vectorField: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs.builder()
            .metadataField(metadataField.applyValue({ args0 -> args0 }))
            .primaryKeyField(primaryKeyField.applyValue({ args0 -> args0 }))
            .textField(textField.applyValue({ args0 -> args0 }))
            .vectorField(vectorField.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgsBuilder internal constructor() {
    private var metadataField: Output<String>? = null

    private var primaryKeyField: Output<String>? = null

    private var textField: Output<String>? = null

    private var vectorField: Output<String>? = null

    /**
     * @param value Name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    @JvmName("tbwtrokddottwjwq")
    public suspend fun metadataField(`value`: Output<String>) {
        this.metadataField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the ID for each entry.
     */
    @JvmName("vicgfuidcejcsegd")
    public suspend fun primaryKeyField(`value`: Output<String>) {
        this.primaryKeyField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
     */
    @JvmName("ppdndkjirpdiecso")
    public suspend fun textField(`value`: Output<String>) {
        this.textField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
     */
    @JvmName("tvlrlcjkogoulcux")
    public suspend fun vectorField(`value`: Output<String>) {
        this.vectorField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    @JvmName("kdkailkksfeyxkqy")
    public suspend fun metadataField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadataField = mapped
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the ID for each entry.
     */
    @JvmName("opcxmmcgjqasnqrb")
    public suspend fun primaryKeyField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryKeyField = mapped
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
     */
    @JvmName("grbwendamincgpqb")
    public suspend fun textField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textField = mapped
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
     */
    @JvmName("uthqlroyjxhjkcfq")
    public suspend fun vectorField(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vectorField = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs =
        AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMappingArgs(
            metadataField = metadataField ?: throw PulumiNullFieldException("metadataField"),
            primaryKeyField = primaryKeyField ?: throw PulumiNullFieldException("primaryKeyField"),
            textField = textField ?: throw PulumiNullFieldException("textField"),
            vectorField = vectorField ?: throw PulumiNullFieldException("vectorField"),
        )
}
