@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property credentialsSecretArn ARN of the secret that you created in AWS Secrets Manager that is linked to your Redis Enterprise Cloud database.
 * @property endpoint Endpoint URL of the Redis Enterprise Cloud database.
 * @property fieldMapping The names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property vectorIndexName Name of the vector index.
 */
public data class AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs(
    public val credentialsSecretArn: Output<String>,
    public val endpoint: Output<String>,
    public val fieldMapping: Output<AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs>? =
        null,
    public val vectorIndexName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs.builder()
            .credentialsSecretArn(credentialsSecretArn.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .fieldMapping(fieldMapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vectorIndexName(vectorIndexName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs].
 */
@PulumiTagMarker
public class AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgsBuilder
internal constructor() {
    private var credentialsSecretArn: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var fieldMapping:
        Output<AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs>? =
        null

    private var vectorIndexName: Output<String>? = null

    /**
     * @param value ARN of the secret that you created in AWS Secrets Manager that is linked to your Redis Enterprise Cloud database.
     */
    @JvmName("osnouarcqkhtpbug")
    public suspend fun credentialsSecretArn(`value`: Output<String>) {
        this.credentialsSecretArn = value
    }

    /**
     * @param value Endpoint URL of the Redis Enterprise Cloud database.
     */
    @JvmName("spwgeiwwwfnffgiw")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("yrivejibwnqchxxj")
    public suspend fun fieldMapping(`value`: Output<AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs>) {
        this.fieldMapping = value
    }

    /**
     * @param value Name of the vector index.
     */
    @JvmName("agqbhguapbclqjnx")
    public suspend fun vectorIndexName(`value`: Output<String>) {
        this.vectorIndexName = value
    }

    /**
     * @param value ARN of the secret that you created in AWS Secrets Manager that is linked to your Redis Enterprise Cloud database.
     */
    @JvmName("lufvvysitmrajrek")
    public suspend fun credentialsSecretArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialsSecretArn = mapped
    }

    /**
     * @param value Endpoint URL of the Redis Enterprise Cloud database.
     */
    @JvmName("ehyuxfrujtvcekdr")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("suhtgoguifhvcxnm")
    public suspend fun fieldMapping(`value`: AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldMapping = mapped
    }

    /**
     * @param argument The names of the fields to which to map information about the vector store. This block supports the following arguments:
     */
    @JvmName("bjcmagfxsjhplnju")
    public suspend fun fieldMapping(argument: suspend AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldMapping = mapped
    }

    /**
     * @param value Name of the vector index.
     */
    @JvmName("uvslgrfmdwsufmol")
    public suspend fun vectorIndexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vectorIndexName = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs = AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationArgs(
        credentialsSecretArn = credentialsSecretArn ?: throw
            PulumiNullFieldException("credentialsSecretArn"),
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        fieldMapping = fieldMapping,
        vectorIndexName = vectorIndexName ?: throw PulumiNullFieldException("vectorIndexName"),
    )
}
