@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataField Name of the field in which Amazon Bedrock stores metadata about the vector store.
 * @property textField Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
 * @property vectorField Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
 */
public data class
AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs(
    public val metadataField: Output<String>? = null,
    public val textField: Output<String>? = null,
    public val vectorField: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs =
        com.pulumi.aws.bedrock.inputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs.builder()
            .metadataField(metadataField?.applyValue({ args0 -> args0 }))
            .textField(textField?.applyValue({ args0 -> args0 }))
            .vectorField(vectorField?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs].
 */
@PulumiTagMarker
public class
AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgsBuilder
internal constructor() {
    private var metadataField: Output<String>? = null

    private var textField: Output<String>? = null

    private var vectorField: Output<String>? = null

    /**
     * @param value Name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    @JvmName("umohqolvklubksus")
    public suspend fun metadataField(`value`: Output<String>) {
        this.metadataField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
     */
    @JvmName("xunbgyduihwjovvi")
    public suspend fun textField(`value`: Output<String>) {
        this.textField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
     */
    @JvmName("ylfonfrwnjbcrahg")
    public suspend fun vectorField(`value`: Output<String>) {
        this.vectorField = value
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    @JvmName("pfrbyomcxvcgvuaa")
    public suspend fun metadataField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataField = mapped
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
     */
    @JvmName("ujxikfqphtqxtntf")
    public suspend fun textField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.textField = mapped
    }

    /**
     * @param value Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
     */
    @JvmName("xesdafudsxunxlte")
    public suspend fun vectorField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vectorField = mapped
    }

    internal fun build(): AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs =
        AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMappingArgs(
            metadataField = metadataField,
            textField = textField,
            vectorField = vectorField,
        )
}
