@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.CustomModelTrainingDataConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Uri The S3 URI where the training data is stored.
 */
public data class CustomModelTrainingDataConfigArgs(
    public val s3Uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.CustomModelTrainingDataConfigArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.CustomModelTrainingDataConfigArgs =
        com.pulumi.aws.bedrock.inputs.CustomModelTrainingDataConfigArgs.builder()
            .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomModelTrainingDataConfigArgs].
 */
@PulumiTagMarker
public class CustomModelTrainingDataConfigArgsBuilder internal constructor() {
    private var s3Uri: Output<String>? = null

    /**
     * @param value The S3 URI where the training data is stored.
     */
    @JvmName("jfoanirajxswydkv")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value The S3 URI where the training data is stored.
     */
    @JvmName("lyoxdaktiqvlftxb")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): CustomModelTrainingDataConfigArgs = CustomModelTrainingDataConfigArgs(
        s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
    )
}
