@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property validators Information about the validators.
 */
public data class CustomModelValidationDataConfigArgs(
    public val validators: Output<List<CustomModelValidationDataConfigValidatorArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigArgs =
        com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigArgs.builder()
            .validators(
                validators?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomModelValidationDataConfigArgs].
 */
@PulumiTagMarker
public class CustomModelValidationDataConfigArgsBuilder internal constructor() {
    private var validators: Output<List<CustomModelValidationDataConfigValidatorArgs>>? = null

    /**
     * @param value Information about the validators.
     */
    @JvmName("sapsfolfljbdlsli")
    public suspend fun validators(`value`: Output<List<CustomModelValidationDataConfigValidatorArgs>>) {
        this.validators = value
    }

    @JvmName("fyfurvrkxwwwufpr")
    public suspend fun validators(vararg values: Output<CustomModelValidationDataConfigValidatorArgs>) {
        this.validators = Output.all(values.asList())
    }

    /**
     * @param values Information about the validators.
     */
    @JvmName("cysqiebuwmiodywh")
    public suspend fun validators(values: List<Output<CustomModelValidationDataConfigValidatorArgs>>) {
        this.validators = Output.all(values)
    }

    /**
     * @param value Information about the validators.
     */
    @JvmName("hjvodxgjjghnueqd")
    public suspend fun validators(`value`: List<CustomModelValidationDataConfigValidatorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validators = mapped
    }

    /**
     * @param argument Information about the validators.
     */
    @JvmName("wtwjqhytxckaplpe")
    public suspend fun validators(argument: List<suspend CustomModelValidationDataConfigValidatorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomModelValidationDataConfigValidatorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.validators = mapped
    }

    /**
     * @param argument Information about the validators.
     */
    @JvmName("gerpbxbjkiubijgy")
    public suspend fun validators(vararg argument: suspend CustomModelValidationDataConfigValidatorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomModelValidationDataConfigValidatorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.validators = mapped
    }

    /**
     * @param argument Information about the validators.
     */
    @JvmName("onkqxluivuqbvupp")
    public suspend fun validators(argument: suspend CustomModelValidationDataConfigValidatorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomModelValidationDataConfigValidatorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.validators = mapped
    }

    /**
     * @param values Information about the validators.
     */
    @JvmName("dmkflchvoebqdjpo")
    public suspend fun validators(vararg values: CustomModelValidationDataConfigValidatorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validators = mapped
    }

    internal fun build(): CustomModelValidationDataConfigArgs = CustomModelValidationDataConfigArgs(
        validators = validators,
    )
}
