@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigValidatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Uri The S3 URI where the validation data is stored.
 */
public data class CustomModelValidationDataConfigValidatorArgs(
    public val s3Uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigValidatorArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigValidatorArgs = com.pulumi.aws.bedrock.inputs.CustomModelValidationDataConfigValidatorArgs.builder()
        .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomModelValidationDataConfigValidatorArgs].
 */
@PulumiTagMarker
public class CustomModelValidationDataConfigValidatorArgsBuilder internal constructor() {
    private var s3Uri: Output<String>? = null

    /**
     * @param value The S3 URI where the validation data is stored.
     */
    @JvmName("ipdilnaowedwfmyy")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value The S3 URI where the validation data is stored.
     */
    @JvmName("wghxymwkrbpotgvb")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): CustomModelValidationDataConfigValidatorArgs =
        CustomModelValidationDataConfigValidatorArgs(
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        )
}
