@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.CustomModelVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds VPC configuration security group IDs.
 * @property subnetIds VPC configuration subnets.
 */
public data class CustomModelVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.CustomModelVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.CustomModelVpcConfigArgs =
        com.pulumi.aws.bedrock.inputs.CustomModelVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CustomModelVpcConfigArgs].
 */
@PulumiTagMarker
public class CustomModelVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value VPC configuration security group IDs.
     */
    @JvmName("vaaidlhaiajbwqcm")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("xvdyceslipvdgbgl")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values VPC configuration security group IDs.
     */
    @JvmName("hucmxfhcoipdesia")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value VPC configuration subnets.
     */
    @JvmName("rjfhkitkcuhiqxma")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("vokusoeclpiigpkw")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values VPC configuration subnets.
     */
    @JvmName("jmtensyyujcibtdr")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value VPC configuration security group IDs.
     */
    @JvmName("srcnwrymqwfotwxu")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values VPC configuration security group IDs.
     */
    @JvmName("occhwqdmdolnqvts")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value VPC configuration subnets.
     */
    @JvmName("eopreabkbrhhojwc")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values VPC configuration subnets.
     */
    @JvmName("huuednemvryaybte")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): CustomModelVpcConfigArgs = CustomModelVpcConfigArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
