@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.inputs

import com.pulumi.aws.bedrock.inputs.GetCustomModelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomModel.
 * @property modelId Name or ARN of the custom model.
 */
public data class GetCustomModelPlainArgs(
    public val modelId: String,
) : ConvertibleToJava<com.pulumi.aws.bedrock.inputs.GetCustomModelPlainArgs> {
    override fun toJava(): com.pulumi.aws.bedrock.inputs.GetCustomModelPlainArgs =
        com.pulumi.aws.bedrock.inputs.GetCustomModelPlainArgs.builder()
            .modelId(modelId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomModelPlainArgs].
 */
@PulumiTagMarker
public class GetCustomModelPlainArgsBuilder internal constructor() {
    private var modelId: String? = null

    /**
     * @param value Name or ARN of the custom model.
     */
    @JvmName("vycgynygmhxylomf")
    public suspend fun modelId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelId = mapped
    }

    internal fun build(): GetCustomModelPlainArgs = GetCustomModelPlainArgs(
        modelId = modelId ?: throw PulumiNullFieldException("modelId"),
    )
}
