@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customControl Custom control method for handling the information elicited from the user. Valid values: `RETURN_CONTROL`.
 * To skip using a Lambda function and instead return the predicted action group, in addition to the parameters and information required for it, in the `InvokeAgent` response, specify `RETURN_CONTROL`.
 * Only one of `custom_control` or `lambda` can be specified.
 * @property lambda ARN of the Lambda function containing the business logic that is carried out upon invoking the action.
 * Only one of `lambda` or `custom_control` can be specified.
 */
public data class AgentAgentActionGroupActionGroupExecutor(
    public val customControl: String? = null,
    public val lambda: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentActionGroupActionGroupExecutor): AgentAgentActionGroupActionGroupExecutor = AgentAgentActionGroupActionGroupExecutor(
            customControl = javaType.customControl().map({ args0 -> args0 }).orElse(null),
            lambda = javaType.lambda().map({ args0 -> args0 }).orElse(null),
        )
    }
}
