@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property payload JSON or YAML-formatted payload defining the OpenAPI schema for the action group.
 * Only one of `payload` or `s3` can be specified.
 * @property s3 Details about the S3 object containing the OpenAPI schema for the action group. See `s3` Block for details.
 * Only one of `s3` or `payload` can be specified.
 */
public data class AgentAgentActionGroupApiSchema(
    public val payload: String? = null,
    public val s3: AgentAgentActionGroupApiSchemaS3? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentActionGroupApiSchema): AgentAgentActionGroupApiSchema = AgentAgentActionGroupApiSchema(
            payload = javaType.payload().map({ args0 -> args0 }).orElse(null),
            s3 = javaType.s3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentActionGroupApiSchemaS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
