@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3BucketName Name of the S3 bucket.
 * @property s3ObjectKey S3 object key containing the resource.
 */
public data class AgentAgentActionGroupApiSchemaS3(
    public val s3BucketName: String? = null,
    public val s3ObjectKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentActionGroupApiSchemaS3): AgentAgentActionGroupApiSchemaS3 = AgentAgentActionGroupApiSchemaS3(
            s3BucketName = javaType.s3BucketName().map({ args0 -> args0 }).orElse(null),
            s3ObjectKey = javaType.s3ObjectKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
