@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description Description of the function and its purpose.
 * @property name Name for the function.
 * @property parameters Parameters that the agent elicits from the user to fulfill the function. See `parameters` Block for details.
 */
public data class AgentAgentActionGroupFunctionSchemaMemberFunctionsFunction(
    public val description: String? = null,
    public val name: String,
    public val parameters: List<AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameter>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunction): AgentAgentActionGroupFunctionSchemaMemberFunctionsFunction =
            AgentAgentActionGroupFunctionSchemaMemberFunctionsFunction(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                parameters = javaType.parameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameter.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
