@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the parameter. Helps the foundation model determine how to elicit the parameters from the user.
 * @property mapBlockKey Name of the parameter.
 * **Note:** The argument name `map_block_key` may seem out of context, but is necessary for backward compatibility reasons in the provider.
 * @property required Whether the parameter is required for the agent to complete the function for action group invocation.
 * @property type Data type of the parameter. Valid values: `string`, `number`, `integer`, `boolean`, `array`.
 */
public data class AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameter(
    public val description: String? = null,
    public val mapBlockKey: String,
    public val required: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameter): AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameter =
            AgentAgentActionGroupFunctionSchemaMemberFunctionsFunctionParameter(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                mapBlockKey = javaType.mapBlockKey(),
                required = javaType.required().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
