@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property agentVersion Version of the agent with which the alias is associated.
 * @property provisionedThroughput ARN of the Provisioned Throughput assigned to the agent alias.
 */
public data class AgentAgentAliasRoutingConfiguration(
    public val agentVersion: String,
    public val provisionedThroughput: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentAliasRoutingConfiguration): AgentAgentAliasRoutingConfiguration = AgentAgentAliasRoutingConfiguration(
            agentVersion = javaType.agentVersion(),
            provisionedThroughput = javaType.provisionedThroughput(),
        )
    }
}
