@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property overrideLambda ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent sequence. If you specify this field, at least one of the `prompt_configurations` block must contain a `parser_mode` value that is set to `OVERRIDDEN`.
 * @property promptConfigurations Configurations to override a prompt template in one part of an agent sequence. See `prompt_configurations` Block for details.
 */
public data class AgentAgentPromptOverrideConfiguration(
    public val overrideLambda: String,
    public val promptConfigurations: List<AgentAgentPromptOverrideConfigurationPromptConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentPromptOverrideConfiguration): AgentAgentPromptOverrideConfiguration = AgentAgentPromptOverrideConfiguration(
            overrideLambda = javaType.overrideLambda(),
            promptConfigurations = javaType.promptConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentPromptOverrideConfigurationPromptConfiguration.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
