@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property basePromptTemplate prompt template with which to replace the default prompt template. You can use placeholder variables in the base prompt template to customize the prompt. For more information, see [Prompt template placeholder variables](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
 * @property inferenceConfigurations Inference parameters to use when the agent invokes a foundation model in the part of the agent sequence defined by the `prompt_type`. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html). See `inference_configuration` Block for details.
 * @property parserMode Whether to override the default parser Lambda function when parsing the raw foundation model output in the part of the agent sequence defined by the `prompt_type`. If you set the argument as `OVERRIDDEN`, the `override_lambda` argument in the `prompt_override_configuration` block must be specified with the ARN of a Lambda function. Valid values: `DEFAULT`, `OVERRIDDEN`.
 * @property promptCreationMode Whether to override the default prompt template for this `prompt_type`. Set this argument to `OVERRIDDEN` to use the prompt that you provide in the `base_prompt_template`. If you leave it as `DEFAULT`, the agent uses a default prompt template. Valid values: `DEFAULT`, `OVERRIDDEN`.
 * @property promptState Whether to allow the agent to carry out the step specified in the `prompt_type`. If you set this argument to `DISABLED`, the agent skips that step. Valid Values: `ENABLED`, `DISABLED`.
 * @property promptType Step in the agent sequence that this prompt configuration applies to. Valid values: `PRE_PROCESSING`, `ORCHESTRATION`, `POST_PROCESSING`, `KNOWLEDGE_BASE_RESPONSE_GENERATION`.
 */
public data class AgentAgentPromptOverrideConfigurationPromptConfiguration(
    public val basePromptTemplate: String,
    public val inferenceConfigurations: List<AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfiguration>,
    public val parserMode: String,
    public val promptCreationMode: String,
    public val promptState: String,
    public val promptType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentPromptOverrideConfigurationPromptConfiguration): AgentAgentPromptOverrideConfigurationPromptConfiguration =
            AgentAgentPromptOverrideConfigurationPromptConfiguration(
                basePromptTemplate = javaType.basePromptTemplate(),
                inferenceConfigurations = javaType.inferenceConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfiguration.Companion.toKotlin(args0)
                    })
                }),
                parserMode = javaType.parserMode(),
                promptCreationMode = javaType.promptCreationMode(),
                promptState = javaType.promptState(),
                promptType = javaType.promptType(),
            )
    }
}
