@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property maxLength Maximum number of tokens to allow in the generated response.
 * @property stopSequences List of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
 * @property temperature Likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
 * @property topK Number of top most-likely candidates, between 0 and 500, from which the model chooses the next token in the sequence.
 * @property topP Top percentage of the probability distribution of next tokens, between 0 and 1 (denoting 0% and 100%), from which the model chooses the next token in the sequence.
 */
public data class AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfiguration(
    public val maxLength: Int,
    public val stopSequences: List<String>,
    public val temperature: Double,
    public val topK: Int,
    public val topP: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfiguration): AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfiguration =
            AgentAgentPromptOverrideConfigurationPromptConfigurationInferenceConfiguration(
                maxLength = javaType.maxLength(),
                stopSequences = javaType.stopSequences().map({ args0 -> args0 }),
                temperature = javaType.temperature(),
                topK = javaType.topK(),
                topP = javaType.topP(),
            )
    }
}
