@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3Configuration Details about the configuration of the S3 object containing the data source. See `s3_data_source_configuration` block for details.
 * @property type Type of storage for the data source. Valid values: `S3`.
 */
public data class AgentDataSourceDataSourceConfiguration(
    public val s3Configuration: AgentDataSourceDataSourceConfigurationS3Configuration? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentDataSourceDataSourceConfiguration): AgentDataSourceDataSourceConfiguration = AgentDataSourceDataSourceConfiguration(
            s3Configuration = javaType.s3Configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceDataSourceConfigurationS3Configuration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
