@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketArn ARN of the bucket that contains the data source.
 * @property bucketOwnerAccountId Bucket account owner ID for the S3 bucket.
 * @property inclusionPrefixes List of S3 prefixes that define the object containing the data sources. For more information, see [Organizing objects using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
 */
public data class AgentDataSourceDataSourceConfigurationS3Configuration(
    public val bucketArn: String,
    public val bucketOwnerAccountId: String? = null,
    public val inclusionPrefixes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentDataSourceDataSourceConfigurationS3Configuration): AgentDataSourceDataSourceConfigurationS3Configuration =
            AgentDataSourceDataSourceConfigurationS3Configuration(
                bucketArn = javaType.bucketArn(),
                bucketOwnerAccountId = javaType.bucketOwnerAccountId().map({ args0 -> args0 }).orElse(null),
                inclusionPrefixes = javaType.inclusionPrefixes().map({ args0 -> args0 }),
            )
    }
}
