@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property chunkingConfiguration Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried. See `chunking_configuration` block for details.
 */
public data class AgentDataSourceVectorIngestionConfiguration(
    public val chunkingConfiguration: AgentDataSourceVectorIngestionConfigurationChunkingConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentDataSourceVectorIngestionConfiguration): AgentDataSourceVectorIngestionConfiguration = AgentDataSourceVectorIngestionConfiguration(
            chunkingConfiguration = javaType.chunkingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceVectorIngestionConfigurationChunkingConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
