@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property chunkingStrategy Option for chunking your source data, either in fixed-sized chunks or as one chunk. Valid values: `FIXED_SIZE`, `NONE`.
 * @property fixedSizeChunkingConfiguration Configurations for when you choose fixed-size chunking. If you set the chunking_strategy as `NONE`, exclude this field. See `fixed_size_chunking_configuration` for details.
 */
public data class AgentDataSourceVectorIngestionConfigurationChunkingConfiguration(
    public val chunkingStrategy: String,
    public val fixedSizeChunkingConfiguration: AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfiguration? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentDataSourceVectorIngestionConfigurationChunkingConfiguration): AgentDataSourceVectorIngestionConfigurationChunkingConfiguration =
            AgentDataSourceVectorIngestionConfigurationChunkingConfiguration(
                chunkingStrategy = javaType.chunkingStrategy(),
                fixedSizeChunkingConfiguration = javaType.fixedSizeChunkingConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentDataSourceVectorIngestionConfigurationChunkingConfigurationFixedSizeChunkingConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
