@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type Type of data that the data source is converted into for the knowledge base. Valid Values: `VECTOR`.
 * @property vectorKnowledgeBaseConfiguration Details about the embeddings model that'sused to convert the data source. See `vector_knowledge_base_configuration` block for details.
 */
public data class AgentKnowledgeBaseKnowledgeBaseConfiguration(
    public val type: String,
    public val vectorKnowledgeBaseConfiguration: AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseKnowledgeBaseConfiguration): AgentKnowledgeBaseKnowledgeBaseConfiguration = AgentKnowledgeBaseKnowledgeBaseConfiguration(
            type = javaType.type(),
            vectorKnowledgeBaseConfiguration = javaType.vectorKnowledgeBaseConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseKnowledgeBaseConfigurationVectorKnowledgeBaseConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
