@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property opensearchServerlessConfiguration The storage configuration of the knowledge base in Amazon OpenSearch Service. See `opensearch_serverless_configuration` block for details.
 * @property pineconeConfiguration The storage configuration of the knowledge base in Pinecone. See `pinecone_configuration` block for details.
 * @property rdsConfiguration Details about the storage configuration of the knowledge base in Amazon RDS. For more information, see [Create a vector index in Amazon RDS](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup.html). See `rds_configuration` block for details.
 * @property redisEnterpriseCloudConfiguration The storage configuration of the knowledge base in Redis Enterprise Cloud. See `redis_enterprise_cloud_configuration` block for details.
 * @property type Vector store service in which the knowledge base is stored. Valid Values: `OPENSEARCH_SERVERLESS`, `PINECONE`, `REDIS_ENTERPRISE_CLOUD`, `RDS`.
 */
public data class AgentKnowledgeBaseStorageConfiguration(
    public val opensearchServerlessConfiguration: AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfiguration? = null,
    public val pineconeConfiguration: AgentKnowledgeBaseStorageConfigurationPineconeConfiguration? =
        null,
    public val rdsConfiguration: AgentKnowledgeBaseStorageConfigurationRdsConfiguration? = null,
    public val redisEnterpriseCloudConfiguration: AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfiguration? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfiguration): AgentKnowledgeBaseStorageConfiguration = AgentKnowledgeBaseStorageConfiguration(
            opensearchServerlessConfiguration = javaType.opensearchServerlessConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pineconeConfiguration = javaType.pineconeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationPineconeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rdsConfiguration = javaType.rdsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationRdsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            redisEnterpriseCloudConfiguration = javaType.redisEnterpriseCloudConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
