@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property collectionArn ARN of the OpenSearch Service vector store.
 * @property fieldMapping The names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property vectorIndexName Name of the vector store.
 */
public data class AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfiguration(
    public val collectionArn: String,
    public val fieldMapping: AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMapping? = null,
    public val vectorIndexName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfiguration): AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfiguration =
            AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfiguration(
                collectionArn = javaType.collectionArn(),
                fieldMapping = javaType.fieldMapping().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMapping.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vectorIndexName = javaType.vectorIndexName(),
            )
    }
}
