@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metadataField Name of the field in which Amazon Bedrock stores metadata about the vector store.
 * @property textField Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
 * @property vectorField Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
 */
public data class
AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMapping(
    public val metadataField: String? = null,
    public val textField: String? = null,
    public val vectorField: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMapping): AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMapping =
            AgentKnowledgeBaseStorageConfigurationOpensearchServerlessConfigurationFieldMapping(
                metadataField = javaType.metadataField().map({ args0 -> args0 }).orElse(null),
                textField = javaType.textField().map({ args0 -> args0 }).orElse(null),
                vectorField = javaType.vectorField().map({ args0 -> args0 }).orElse(null),
            )
    }
}
