@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionString Endpoint URL for your index management page.
 * @property credentialsSecretArn ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
 * @property fieldMapping The names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property namespace Namespace to be used to write new data to your database.
 */
public data class AgentKnowledgeBaseStorageConfigurationPineconeConfiguration(
    public val connectionString: String,
    public val credentialsSecretArn: String,
    public val fieldMapping: AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMapping? =
        null,
    public val namespace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationPineconeConfiguration): AgentKnowledgeBaseStorageConfigurationPineconeConfiguration =
            AgentKnowledgeBaseStorageConfigurationPineconeConfiguration(
                connectionString = javaType.connectionString(),
                credentialsSecretArn = javaType.credentialsSecretArn(),
                fieldMapping = javaType.fieldMapping().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMapping.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            )
    }
}
