@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metadataField Name of the field in which Amazon Bedrock stores metadata about the vector store.
 * @property textField Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
 */
public data class AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMapping(
    public val metadataField: String? = null,
    public val textField: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMapping): AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMapping =
            AgentKnowledgeBaseStorageConfigurationPineconeConfigurationFieldMapping(
                metadataField = javaType.metadataField().map({ args0 -> args0 }).orElse(null),
                textField = javaType.textField().map({ args0 -> args0 }).orElse(null),
            )
    }
}
