@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property credentialsSecretArn ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
 * @property databaseName Name of your Amazon RDS database.
 * @property fieldMapping Names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property resourceArn ARN of the vector store.
 * @property tableName Name of the table in the database.
 */
public data class AgentKnowledgeBaseStorageConfigurationRdsConfiguration(
    public val credentialsSecretArn: String,
    public val databaseName: String,
    public val fieldMapping: AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMapping? =
        null,
    public val resourceArn: String,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationRdsConfiguration): AgentKnowledgeBaseStorageConfigurationRdsConfiguration =
            AgentKnowledgeBaseStorageConfigurationRdsConfiguration(
                credentialsSecretArn = javaType.credentialsSecretArn(),
                databaseName = javaType.databaseName(),
                fieldMapping = javaType.fieldMapping().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMapping.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                resourceArn = javaType.resourceArn(),
                tableName = javaType.tableName(),
            )
    }
}
