@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metadataField Name of the field in which Amazon Bedrock stores metadata about the vector store.
 * @property primaryKeyField Name of the field in which Amazon Bedrock stores the ID for each entry.
 * @property textField Name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
 * @property vectorField Name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
 */
public data class AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMapping(
    public val metadataField: String,
    public val primaryKeyField: String,
    public val textField: String,
    public val vectorField: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMapping): AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMapping =
            AgentKnowledgeBaseStorageConfigurationRdsConfigurationFieldMapping(
                metadataField = javaType.metadataField(),
                primaryKeyField = javaType.primaryKeyField(),
                textField = javaType.textField(),
                vectorField = javaType.vectorField(),
            )
    }
}
