@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property credentialsSecretArn ARN of the secret that you created in AWS Secrets Manager that is linked to your Redis Enterprise Cloud database.
 * @property endpoint Endpoint URL of the Redis Enterprise Cloud database.
 * @property fieldMapping The names of the fields to which to map information about the vector store. This block supports the following arguments:
 * @property vectorIndexName Name of the vector index.
 */
public data class AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfiguration(
    public val credentialsSecretArn: String,
    public val endpoint: String,
    public val fieldMapping: AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMapping? = null,
    public val vectorIndexName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfiguration): AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfiguration =
            AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfiguration(
                credentialsSecretArn = javaType.credentialsSecretArn(),
                endpoint = javaType.endpoint(),
                fieldMapping = javaType.fieldMapping().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.bedrock.kotlin.outputs.AgentKnowledgeBaseStorageConfigurationRedisEnterpriseCloudConfigurationFieldMapping.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vectorIndexName = javaType.vectorIndexName(),
            )
    }
}
