@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds VPC configuration security group IDs.
 * @property subnetIds VPC configuration subnets.
 */
public data class CustomModelVpcConfig(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.CustomModelVpcConfig): CustomModelVpcConfig = CustomModelVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
