@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCustomModel.
 * @property baseModelArn ARN of the base model.
 * @property creationTime Creation time of the model.
 * @property hyperparameters Hyperparameter values associated with this model.
 * @property id
 * @property jobArn Job ARN associated with this model.
 * @property jobName Job name associated with this model.
 * @property jobTags Key-value mapping of tags for the fine-tuning job.
 * @property modelArn ARN associated with this model.
 * @property modelId
 * @property modelKmsKeyArn The custom model is encrypted at rest using this key.
 * @property modelName Model name associated with this model.
 * @property modelTags Key-value mapping of tags for the model.
 * @property outputDataConfigs Output data configuration associated with this custom model.
 * @property trainingDataConfigs Information about the training dataset.
 * @property trainingMetrics Metrics associated with the customization job.
 * @property validationDataConfigs Information about the validation dataset.
 * @property validationMetrics The loss metric for each validator that you provided.
 */
public data class GetCustomModelResult(
    public val baseModelArn: String,
    public val creationTime: String,
    public val hyperparameters: Map<String, String>,
    public val id: String,
    public val jobArn: String,
    public val jobName: String,
    public val jobTags: Map<String, String>,
    public val modelArn: String,
    public val modelId: String,
    public val modelKmsKeyArn: String,
    public val modelName: String,
    public val modelTags: Map<String, String>,
    public val outputDataConfigs: List<GetCustomModelOutputDataConfig>,
    public val trainingDataConfigs: List<GetCustomModelTrainingDataConfig>,
    public val trainingMetrics: List<GetCustomModelTrainingMetric>,
    public val validationDataConfigs: List<GetCustomModelValidationDataConfig>,
    public val validationMetrics: List<GetCustomModelValidationMetric>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.GetCustomModelResult): GetCustomModelResult = GetCustomModelResult(
            baseModelArn = javaType.baseModelArn(),
            creationTime = javaType.creationTime(),
            hyperparameters = javaType.hyperparameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            jobArn = javaType.jobArn(),
            jobName = javaType.jobName(),
            jobTags = javaType.jobTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            modelArn = javaType.modelArn(),
            modelId = javaType.modelId(),
            modelKmsKeyArn = javaType.modelKmsKeyArn(),
            modelName = javaType.modelName(),
            modelTags = javaType.modelTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            outputDataConfigs = javaType.outputDataConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelOutputDataConfig.Companion.toKotlin(args0)
                })
            }),
            trainingDataConfigs = javaType.trainingDataConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelTrainingDataConfig.Companion.toKotlin(args0)
                })
            }),
            trainingMetrics = javaType.trainingMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelTrainingMetric.Companion.toKotlin(args0)
                })
            }),
            validationDataConfigs = javaType.validationDataConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelValidationDataConfig.Companion.toKotlin(args0)
                })
            }),
            validationMetrics = javaType.validationMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelValidationMetric.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
