@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creationTime Creation time of the model.
 * @property modelArn The ARN of the custom model.
 * @property modelName The name of the custom model.
 */
public data class GetCustomModelsModelSummary(
    public val creationTime: String,
    public val modelArn: String,
    public val modelName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.GetCustomModelsModelSummary): GetCustomModelsModelSummary = GetCustomModelsModelSummary(
            creationTime = javaType.creationTime(),
            modelArn = javaType.modelArn(),
            modelName = javaType.modelName(),
        )
    }
}
