@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrock.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomModels.
 * @property id
 * @property modelSummaries Model summaries.
 */
public data class GetCustomModelsResult(
    public val id: String,
    public val modelSummaries: List<GetCustomModelsModelSummary>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrock.outputs.GetCustomModelsResult): GetCustomModelsResult = GetCustomModelsResult(
            id = javaType.id(),
            modelSummaries = javaType.modelSummaries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrock.kotlin.outputs.GetCustomModelsModelSummary.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
