@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin

import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions.getModelPlain
import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions.getModelsPlain
import com.pulumi.aws.bedrockfoundation.kotlin.inputs.GetModelPlainArgs
import com.pulumi.aws.bedrockfoundation.kotlin.inputs.GetModelPlainArgsBuilder
import com.pulumi.aws.bedrockfoundation.kotlin.inputs.GetModelsPlainArgs
import com.pulumi.aws.bedrockfoundation.kotlin.inputs.GetModelsPlainArgsBuilder
import com.pulumi.aws.bedrockfoundation.kotlin.outputs.GetModelResult
import com.pulumi.aws.bedrockfoundation.kotlin.outputs.GetModelsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.bedrockfoundation.kotlin.outputs.GetModelResult.Companion.toKotlin as getModelResultToKotlin
import com.pulumi.aws.bedrockfoundation.kotlin.outputs.GetModelsResult.Companion.toKotlin as getModelsResultToKotlin

public object BedrockfoundationFunctions {
    /**
     * Data source for managing an AWS Bedrock Foundation Model.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.bedrockfoundation.getModels({});
     * const testGetModel = test.then(test => aws.bedrockfoundation.getModel({
     *     modelId: test.modelSummaries?.[0]?.modelId,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.bedrockfoundation.get_models()
     * test_get_model = aws.bedrockfoundation.get_model(model_id=test.model_summaries[0].model_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.BedrockFoundation.GetModels.Invoke();
     *     var testGetModel = Aws.BedrockFoundation.GetModel.Invoke(new()
     *     {
     *         ModelId = test.Apply(getModelsResult => getModelsResult.ModelSummaries[0]?.ModelId),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrockfoundation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		test, err := bedrockfoundation.GetModels(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = bedrockfoundation.GetModel(ctx, &bedrockfoundation.GetModelArgs{
     * 			ModelId: test.ModelSummaries[0].ModelId,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions;
     * import com.pulumi.aws.bedrockfoundation.inputs.GetModelsArgs;
     * import com.pulumi.aws.bedrockfoundation.inputs.GetModelArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BedrockfoundationFunctions.getModels();
     *         final var testGetModel = BedrockfoundationFunctions.getModel(GetModelArgs.builder()
     *             .modelId(test.applyValue(getModelsResult -> getModelsResult.modelSummaries()[0].modelId()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:bedrockfoundation:getModels
     *       Arguments: {}
     *   testGetModel:
     *     fn::invoke:
     *       Function: aws:bedrockfoundation:getModel
     *       Arguments:
     *         modelId: ${test.modelSummaries[0].modelId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getModel.
     * @return A collection of values returned by getModel.
     */
    public suspend fun getModel(argument: GetModelPlainArgs): GetModelResult =
        getModelResultToKotlin(getModelPlain(argument.toJava()).await())

    /**
     * @see [getModel].
     * @param modelId Model identifier.
     * @return A collection of values returned by getModel.
     */
    public suspend fun getModel(modelId: String): GetModelResult {
        val argument = GetModelPlainArgs(
            modelId = modelId,
        )
        return getModelResultToKotlin(getModelPlain(argument.toJava()).await())
    }

    /**
     * @see [getModel].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;bedrockfoundation&#46;kotlin&#46;inputs&#46;GetModelPlainArgs].
     * @return A collection of values returned by getModel.
     */
    public suspend fun getModel(argument: suspend GetModelPlainArgsBuilder.() -> Unit): GetModelResult {
        val builder = GetModelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModelResultToKotlin(getModelPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS Bedrock Foundation Models.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.bedrockfoundation.getModels({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.bedrockfoundation.get_models()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.BedrockFoundation.GetModels.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrockfoundation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bedrockfoundation.GetModels(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions;
     * import com.pulumi.aws.bedrockfoundation.inputs.GetModelsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BedrockfoundationFunctions.getModels();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:bedrockfoundation:getModels
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter by Inference Type
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.bedrockfoundation.getModels({
     *     byInferenceType: "ON_DEMAND",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.bedrockfoundation.get_models(by_inference_type="ON_DEMAND")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.BedrockFoundation.GetModels.Invoke(new()
     *     {
     *         ByInferenceType = "ON_DEMAND",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/bedrockfoundation"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := bedrockfoundation.GetModels(ctx, &bedrockfoundation.GetModelsArgs{
     * 			ByInferenceType: pulumi.StringRef("ON_DEMAND"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.bedrockfoundation.BedrockfoundationFunctions;
     * import com.pulumi.aws.bedrockfoundation.inputs.GetModelsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BedrockfoundationFunctions.getModels(GetModelsArgs.builder()
     *             .byInferenceType("ON_DEMAND")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:bedrockfoundation:getModels
     *       Arguments:
     *         byInferenceType: ON_DEMAND
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getModels.
     * @return A collection of values returned by getModels.
     */
    public suspend fun getModels(argument: GetModelsPlainArgs): GetModelsResult =
        getModelsResultToKotlin(getModelsPlain(argument.toJava()).await())

    /**
     * @see [getModels].
     * @param byCustomizationType Customization type to filter on. Valid values are `FINE_TUNING`.
     * @param byInferenceType Inference type to filter on. Valid values are `ON_DEMAND` and `PROVISIONED`.
     * @param byOutputModality Output modality to filter on. Valid values are `TEXT`, `IMAGE`, and `EMBEDDING`.
     * @param byProvider Model provider to filter on.
     * @return A collection of values returned by getModels.
     */
    public suspend fun getModels(
        byCustomizationType: String? = null,
        byInferenceType: String? = null,
        byOutputModality: String? = null,
        byProvider: String? = null,
    ): GetModelsResult {
        val argument = GetModelsPlainArgs(
            byCustomizationType = byCustomizationType,
            byInferenceType = byInferenceType,
            byOutputModality = byOutputModality,
            byProvider = byProvider,
        )
        return getModelsResultToKotlin(getModelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getModels].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;bedrockfoundation&#46;kotlin&#46;inputs&#46;GetModelsPlainArgs].
     * @return A collection of values returned by getModels.
     */
    public suspend fun getModels(argument: suspend GetModelsPlainArgsBuilder.() -> Unit): GetModelsResult {
        val builder = GetModelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModelsResultToKotlin(getModelsPlain(builtArgument.toJava()).await())
    }
}
