@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin.inputs

import com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getModels.
 * @property byCustomizationType Customization type to filter on. Valid values are `FINE_TUNING`.
 * @property byInferenceType Inference type to filter on. Valid values are `ON_DEMAND` and `PROVISIONED`.
 * @property byOutputModality Output modality to filter on. Valid values are `TEXT`, `IMAGE`, and `EMBEDDING`.
 * @property byProvider Model provider to filter on.
 */
public data class GetModelsPlainArgs(
    public val byCustomizationType: String? = null,
    public val byInferenceType: String? = null,
    public val byOutputModality: String? = null,
    public val byProvider: String? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs> {
    override fun toJava(): com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs =
        com.pulumi.aws.bedrockfoundation.inputs.GetModelsPlainArgs.builder()
            .byCustomizationType(byCustomizationType?.let({ args0 -> args0 }))
            .byInferenceType(byInferenceType?.let({ args0 -> args0 }))
            .byOutputModality(byOutputModality?.let({ args0 -> args0 }))
            .byProvider(byProvider?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModelsPlainArgs].
 */
@PulumiTagMarker
public class GetModelsPlainArgsBuilder internal constructor() {
    private var byCustomizationType: String? = null

    private var byInferenceType: String? = null

    private var byOutputModality: String? = null

    private var byProvider: String? = null

    /**
     * @param value Customization type to filter on. Valid values are `FINE_TUNING`.
     */
    @JvmName("buqrgqnapnxqtoei")
    public suspend fun byCustomizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byCustomizationType = mapped
    }

    /**
     * @param value Inference type to filter on. Valid values are `ON_DEMAND` and `PROVISIONED`.
     */
    @JvmName("abkitmdpmmysuiou")
    public suspend fun byInferenceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byInferenceType = mapped
    }

    /**
     * @param value Output modality to filter on. Valid values are `TEXT`, `IMAGE`, and `EMBEDDING`.
     */
    @JvmName("pqlchkqtwchjfsik")
    public suspend fun byOutputModality(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byOutputModality = mapped
    }

    /**
     * @param value Model provider to filter on.
     */
    @JvmName("xwxywgeanketlnga")
    public suspend fun byProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byProvider = mapped
    }

    internal fun build(): GetModelsPlainArgs = GetModelsPlainArgs(
        byCustomizationType = byCustomizationType,
        byInferenceType = byInferenceType,
        byOutputModality = byOutputModality,
        byProvider = byProvider,
    )
}
