@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customizationsSupporteds Customizations that the model supports.
 * @property inferenceTypesSupporteds Inference types that the model supports.
 * @property inputModalities Input modalities that the model supports.
 * @property modelArn Model ARN.
 * @property modelId Model identifier.
 * @property modelName Model name.
 * @property outputModalities Output modalities that the model supports.
 * @property providerName Model provider name.
 * @property responseStreamingSupported Indicates whether the model supports streaming.
 */
public data class GetModelsModelSummary(
    public val customizationsSupporteds: List<String>,
    public val inferenceTypesSupporteds: List<String>,
    public val inputModalities: List<String>,
    public val modelArn: String,
    public val modelId: String,
    public val modelName: String,
    public val outputModalities: List<String>,
    public val providerName: String,
    public val responseStreamingSupported: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrockfoundation.outputs.GetModelsModelSummary): GetModelsModelSummary = GetModelsModelSummary(
            customizationsSupporteds = javaType.customizationsSupporteds().map({ args0 -> args0 }),
            inferenceTypesSupporteds = javaType.inferenceTypesSupporteds().map({ args0 -> args0 }),
            inputModalities = javaType.inputModalities().map({ args0 -> args0 }),
            modelArn = javaType.modelArn(),
            modelId = javaType.modelId(),
            modelName = javaType.modelName(),
            outputModalities = javaType.outputModalities().map({ args0 -> args0 }),
            providerName = javaType.providerName(),
            responseStreamingSupported = javaType.responseStreamingSupported(),
        )
    }
}
