@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockfoundation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getModels.
 * @property byCustomizationType
 * @property byInferenceType
 * @property byOutputModality
 * @property byProvider
 * @property id AWS region.
 * @property modelSummaries List of model summary objects. See `model_summaries`.
 */
public data class GetModelsResult(
    public val byCustomizationType: String? = null,
    public val byInferenceType: String? = null,
    public val byOutputModality: String? = null,
    public val byProvider: String? = null,
    public val id: String,
    public val modelSummaries: List<GetModelsModelSummary>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.bedrockfoundation.outputs.GetModelsResult): GetModelsResult = GetModelsResult(
            byCustomizationType = javaType.byCustomizationType().map({ args0 -> args0 }).orElse(null),
            byInferenceType = javaType.byInferenceType().map({ args0 -> args0 }).orElse(null),
            byOutputModality = javaType.byOutputModality().map({ args0 -> args0 }).orElse(null),
            byProvider = javaType.byProvider().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            modelSummaries = javaType.modelSummaries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.bedrockfoundation.kotlin.outputs.GetModelsModelSummary.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
