@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin

import com.pulumi.aws.bedrockmodel.kotlin.outputs.InvocationLoggingConfigurationLoggingConfig
import com.pulumi.aws.bedrockmodel.kotlin.outputs.InvocationLoggingConfigurationLoggingConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InvocationLoggingConfiguration].
 */
@PulumiTagMarker
public class InvocationLoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InvocationLoggingConfigurationArgs = InvocationLoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InvocationLoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = InvocationLoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InvocationLoggingConfiguration {
        val builtJavaResource =
            com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InvocationLoggingConfiguration(builtJavaResource)
    }
}

/**
 * Manages Bedrock model invocation logging configuration.
 * > Model invocation logging is configured per AWS region. To avoid overwriting settings, this resource should not be defined in multiple configurations.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration;
 * import com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(example.bucket())
 *             .policy(example.arn().applyValue(arn -> """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Principal": {
 *         "Service": "bedrock.amazonaws.com"
 *       },
 *       "Action": [
 *         "s3:*"
 *       ],
 *       "Resource": [
 *         "%s/*"
 *       ],
 *       "Condition": {
 *         "StringEquals": {
 *           "aws:SourceAccount": "%s"
 *         },
 *         "ArnLike": {
 *           "aws:SourceArn": "arn:aws:bedrock:us-east-1:%s:*"
 *         }
 *       }
 *     }
 *   ]
 * }
 * ", arn,current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *             .build());
 *         var exampleInvocationLoggingConfiguration = new InvocationLoggingConfiguration("exampleInvocationLoggingConfiguration", InvocationLoggingConfigurationArgs.builder()
 *             .loggingConfig(InvocationLoggingConfigurationLoggingConfigArgs.builder()
 *                 .embeddingDataDeliveryEnabled(true)
 *                 .imageDataDeliveryEnabled(true)
 *                 .textDataDeliveryEnabled(true)
 *                 .s3Config(InvocationLoggingConfigurationLoggingConfigS3ConfigArgs.builder()
 *                     .bucketName(example.id())
 *                     .keyPrefix("bedrock")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *       forceDestroy: true
 *   exampleBucketPolicy:
 *     type: aws:s3:BucketPolicy
 *     name: example
 *     properties:
 *       bucket: ${example.bucket}
 *       policy: |
 *         {
 *           "Version": "2012-10-17",
 *           "Statement": [
 *             {
 *               "Effect": "Allow",
 *               "Principal": {
 *                 "Service": "bedrock.amazonaws.com"
 *               },
 *               "Action": [
 *                 "s3:*"
 *               ],
 *               "Resource": [
 *                 "${example.arn}/*"
 *               ],
 *               "Condition": {
 *                 "StringEquals": {
 *                   "aws:SourceAccount": "${current.accountId}"
 *                 },
 *                 "ArnLike": {
 *                   "aws:SourceArn": "arn:aws:bedrock:us-east-1:${current.accountId}:*"
 *                 }
 *               }
 *             }
 *           ]
 *         }
 *   exampleInvocationLoggingConfiguration:
 *     type: aws:bedrockmodel:InvocationLoggingConfiguration
 *     name: example
 *     properties:
 *       loggingConfig:
 *         - embeddingDataDeliveryEnabled: true
 *           imageDataDeliveryEnabled: true
 *           textDataDeliveryEnabled: true
 *           s3Config:
 *             - bucketName: ${example.id}
 *               keyPrefix: bedrock
 *     options:
 *       dependson:
 *         - ${exampleBucketPolicy}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Bedrock custom model using the `id` set to the AWS Region. For example:
 * ```sh
 * $ pulumi import aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration my_config us-east-1
 * ```
 * */*/
 */
public class InvocationLoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration,
) : KotlinCustomResource(javaResource, InvocationLoggingConfigurationMapper) {
    /**
     * The logging configuration values to set.
     */
    public val loggingConfig: Output<InvocationLoggingConfigurationLoggingConfig>?
        get() = javaResource.loggingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object InvocationLoggingConfigurationMapper : ResourceMapper<InvocationLoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): InvocationLoggingConfiguration =
        InvocationLoggingConfiguration(
            javaResource as
                com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration,
        )
}

/**
 * @see [InvocationLoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InvocationLoggingConfiguration].
 */
public suspend fun invocationLoggingConfiguration(
    name: String,
    block: suspend InvocationLoggingConfigurationResourceBuilder.() -> Unit,
): InvocationLoggingConfiguration {
    val builder = InvocationLoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InvocationLoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun invocationLoggingConfiguration(name: String): InvocationLoggingConfiguration {
    val builder = InvocationLoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
