@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.bedrockmodel.kotlin

import com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs.builder
import com.pulumi.aws.bedrockmodel.kotlin.inputs.InvocationLoggingConfigurationLoggingConfigArgs
import com.pulumi.aws.bedrockmodel.kotlin.inputs.InvocationLoggingConfigurationLoggingConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages Bedrock model invocation logging configuration.
 * > Model invocation logging is configured per AWS region. To avoid overwriting settings, this resource should not be defined in multiple configurations.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.bedrockmodel.InvocationLoggingConfiguration;
 * import com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(example.bucket())
 *             .policy(example.arn().applyValue(arn -> """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Principal": {
 *         "Service": "bedrock.amazonaws.com"
 *       },
 *       "Action": [
 *         "s3:*"
 *       ],
 *       "Resource": [
 *         "%s/*"
 *       ],
 *       "Condition": {
 *         "StringEquals": {
 *           "aws:SourceAccount": "%s"
 *         },
 *         "ArnLike": {
 *           "aws:SourceArn": "arn:aws:bedrock:us-east-1:%s:*"
 *         }
 *       }
 *     }
 *   ]
 * }
 * ", arn,current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()),current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *             .build());
 *         var exampleInvocationLoggingConfiguration = new InvocationLoggingConfiguration("exampleInvocationLoggingConfiguration", InvocationLoggingConfigurationArgs.builder()
 *             .loggingConfig(InvocationLoggingConfigurationLoggingConfigArgs.builder()
 *                 .embeddingDataDeliveryEnabled(true)
 *                 .imageDataDeliveryEnabled(true)
 *                 .textDataDeliveryEnabled(true)
 *                 .s3Config(InvocationLoggingConfigurationLoggingConfigS3ConfigArgs.builder()
 *                     .bucketName(example.id())
 *                     .keyPrefix("bedrock")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *       forceDestroy: true
 *   exampleBucketPolicy:
 *     type: aws:s3:BucketPolicy
 *     name: example
 *     properties:
 *       bucket: ${example.bucket}
 *       policy: |
 *         {
 *           "Version": "2012-10-17",
 *           "Statement": [
 *             {
 *               "Effect": "Allow",
 *               "Principal": {
 *                 "Service": "bedrock.amazonaws.com"
 *               },
 *               "Action": [
 *                 "s3:*"
 *               ],
 *               "Resource": [
 *                 "${example.arn}/*"
 *               ],
 *               "Condition": {
 *                 "StringEquals": {
 *                   "aws:SourceAccount": "${current.accountId}"
 *                 },
 *                 "ArnLike": {
 *                   "aws:SourceArn": "arn:aws:bedrock:us-east-1:${current.accountId}:*"
 *                 }
 *               }
 *             }
 *           ]
 *         }
 *   exampleInvocationLoggingConfiguration:
 *     type: aws:bedrockmodel:InvocationLoggingConfiguration
 *     name: example
 *     properties:
 *       loggingConfig:
 *         - embeddingDataDeliveryEnabled: true
 *           imageDataDeliveryEnabled: true
 *           textDataDeliveryEnabled: true
 *           s3Config:
 *             - bucketName: ${example.id}
 *               keyPrefix: bedrock
 *     options:
 *       dependson:
 *         - ${exampleBucketPolicy}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Bedrock custom model using the `id` set to the AWS Region. For example:
 * ```sh
 * $ pulumi import aws:bedrockmodel/invocationLoggingConfiguration:InvocationLoggingConfiguration my_config us-east-1
 * ```
 * @property loggingConfig The logging configuration values to set.
 * */*/
 */
public data class InvocationLoggingConfigurationArgs(
    public val loggingConfig: Output<InvocationLoggingConfigurationLoggingConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs =
        com.pulumi.aws.bedrockmodel.InvocationLoggingConfigurationArgs.builder()
            .loggingConfig(loggingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InvocationLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class InvocationLoggingConfigurationArgsBuilder internal constructor() {
    private var loggingConfig: Output<InvocationLoggingConfigurationLoggingConfigArgs>? = null

    /**
     * @param value The logging configuration values to set.
     */
    @JvmName("cfuolqvwrheecybh")
    public suspend fun loggingConfig(`value`: Output<InvocationLoggingConfigurationLoggingConfigArgs>) {
        this.loggingConfig = value
    }

    /**
     * @param value The logging configuration values to set.
     */
    @JvmName("rlwbxsbengdoganv")
    public suspend fun loggingConfig(`value`: InvocationLoggingConfigurationLoggingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfig = mapped
    }

    /**
     * @param argument The logging configuration values to set.
     */
    @JvmName("xojdwhtwuktinvcc")
    public suspend fun loggingConfig(argument: suspend InvocationLoggingConfigurationLoggingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InvocationLoggingConfigurationLoggingConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingConfig = mapped
    }

    internal fun build(): InvocationLoggingConfigurationArgs = InvocationLoggingConfigurationArgs(
        loggingConfig = loggingConfig,
    )
}
