@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.kotlin.outputs.BudgetAutoAdjustData
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostFilter
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostTypes
import com.pulumi.aws.budgets.kotlin.outputs.BudgetNotification
import com.pulumi.aws.budgets.kotlin.outputs.BudgetPlannedLimit
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.budgets.kotlin.outputs.BudgetAutoAdjustData.Companion.toKotlin as budgetAutoAdjustDataToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostFilter.Companion.toKotlin as budgetCostFilterToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetCostTypes.Companion.toKotlin as budgetCostTypesToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetNotification.Companion.toKotlin as budgetNotificationToKotlin
import com.pulumi.aws.budgets.kotlin.outputs.BudgetPlannedLimit.Companion.toKotlin as budgetPlannedLimitToKotlin

/**
 * Builder for [Budget].
 */
@PulumiTagMarker
public class BudgetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetArgs = BudgetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetArgsBuilder.() -> Unit) {
        val builder = BudgetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Budget {
        val builtJavaResource = com.pulumi.aws.budgets.Budget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Budget(builtJavaResource)
    }
}

/**
 * Provides a budgets budget resource. Budgets use the cost visualization provided by Cost Explorer to show you the status of your budgets, to provide forecasts of your estimated costs, and to track your AWS usage, including your free tier usage.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ec2 = new aws.budgets.Budget("ec2", {
 *     name: "budget-ec2-monthly",
 *     budgetType: "COST",
 *     limitAmount: "1200",
 *     limitUnit: "USD",
 *     timePeriodEnd: "2087-06-15_00:00",
 *     timePeriodStart: "2017-07-01_00:00",
 *     timeUnit: "MONTHLY",
 *     costFilters: [{
 *         name: "Service",
 *         values: ["Amazon Elastic Compute Cloud - Compute"],
 *     }],
 *     notifications: [{
 *         comparisonOperator: "GREATER_THAN",
 *         threshold: 100,
 *         thresholdType: "PERCENTAGE",
 *         notificationType: "FORECASTED",
 *         subscriberEmailAddresses: ["test@example&#46;com"],
 *     }],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ec2 = aws.budgets.Budget("ec2",
 *     name="budget-ec2-monthly",
 *     budget_type="COST",
 *     limit_amount="1200",
 *     limit_unit="USD",
 *     time_period_end="2087-06-15_00:00",
 *     time_period_start="2017-07-01_00:00",
 *     time_unit="MONTHLY",
 *     cost_filters=[{
 *         "name": "Service",
 *         "values": ["Amazon Elastic Compute Cloud - Compute"],
 *     }],
 *     notifications=[{
 *         "comparison_operator": "GREATER_THAN",
 *         "threshold": 100,
 *         "threshold_type": "PERCENTAGE",
 *         "notification_type": "FORECASTED",
 *         "subscriber_email_addresses": ["test@example&#46;com"],
 *     }],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ec2 = new Aws.Budgets.Budget("ec2", new()
 *     {
 *         Name = "budget-ec2-monthly",
 *         BudgetType = "COST",
 *         LimitAmount = "1200",
 *         LimitUnit = "USD",
 *         TimePeriodEnd = "2087-06-15_00:00",
 *         TimePeriodStart = "2017-07-01_00:00",
 *         TimeUnit = "MONTHLY",
 *         CostFilters = new[]
 *         {
 *             new Aws.Budgets.Inputs.BudgetCostFilterArgs
 *             {
 *                 Name = "Service",
 *                 Values = new[]
 *                 {
 *                     "Amazon Elastic Compute Cloud - Compute",
 *                 },
 *             },
 *         },
 *         Notifications = new[]
 *         {
 *             new Aws.Budgets.Inputs.BudgetNotificationArgs
 *             {
 *                 ComparisonOperator = "GREATER_THAN",
 *                 Threshold = 100,
 *                 ThresholdType = "PERCENTAGE",
 *                 NotificationType = "FORECASTED",
 *                 SubscriberEmailAddresses = new[]
 *                 {
 *                     "test@example.com",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "ec2", &budgets.BudgetArgs{
 * 			Name:            pulumi.String("budget-ec2-monthly"),
 * 			BudgetType:      pulumi.String("COST"),
 * 			LimitAmount:     pulumi.String("1200"),
 * 			LimitUnit:       pulumi.String("USD"),
 * 			TimePeriodEnd:   pulumi.String("2087-06-15_00:00"),
 * 			TimePeriodStart: pulumi.String("2017-07-01_00:00"),
 * 			TimeUnit:        pulumi.String("MONTHLY"),
 * 			CostFilters: budgets.BudgetCostFilterArray{
 * 				&budgets.BudgetCostFilterArgs{
 * 					Name: pulumi.String("Service"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("Amazon Elastic Compute Cloud - Compute"),
 * 					},
 * 				},
 * 			},
 * 			Notifications: budgets.BudgetNotificationArray{
 * 				&budgets.BudgetNotificationArgs{
 * 					ComparisonOperator: pulumi.String("GREATER_THAN"),
 * 					Threshold:          pulumi.Float64(100),
 * 					ThresholdType:      pulumi.String("PERCENTAGE"),
 * 					NotificationType:   pulumi.String("FORECASTED"),
 * 					SubscriberEmailAddresses: pulumi.StringArray{
 * 						pulumi.String("test@example.com"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new Budget("ec2", BudgetArgs.builder()
 *             .name("budget-ec2-monthly")
 *             .budgetType("COST")
 *             .limitAmount("1200")
 *             .limitUnit("USD")
 *             .timePeriodEnd("2087-06-15_00:00")
 *             .timePeriodStart("2017-07-01_00:00")
 *             .timeUnit("MONTHLY")
 *             .costFilters(BudgetCostFilterArgs.builder()
 *                 .name("Service")
 *                 .values("Amazon Elastic Compute Cloud - Compute")
 *                 .build())
 *             .notifications(BudgetNotificationArgs.builder()
 *                 .comparisonOperator("GREATER_THAN")
 *                 .threshold(100)
 *                 .thresholdType("PERCENTAGE")
 *                 .notificationType("FORECASTED")
 *                 .subscriberEmailAddresses("test@example.com")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ec2:
 *     type: aws:budgets:Budget
 *     properties:
 *       name: budget-ec2-monthly
 *       budgetType: COST
 *       limitAmount: '1200'
 *       limitUnit: USD
 *       timePeriodEnd: 2087-06-15_00:00
 *       timePeriodStart: 2017-07-01_00:00
 *       timeUnit: MONTHLY
 *       costFilters:
 *         - name: Service
 *           values:
 *             - Amazon Elastic Compute Cloud - Compute
 *       notifications:
 *         - comparisonOperator: GREATER_THAN
 *           threshold: 100
 *           thresholdType: PERCENTAGE
 *           notificationType: FORECASTED
 *           subscriberEmailAddresses:
 *             - test@example.com
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a budget for *$100*.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cost = new aws.budgets.Budget("cost", {
 *     budgetType: "COST",
 *     limitAmount: "100",
 *     limitUnit: "USD",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cost = aws.budgets.Budget("cost",
 *     budget_type="COST",
 *     limit_amount="100",
 *     limit_unit="USD")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cost = new Aws.Budgets.Budget("cost", new()
 *     {
 *         BudgetType = "COST",
 *         LimitAmount = "100",
 *         LimitUnit = "USD",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "cost", &budgets.BudgetArgs{
 * 			BudgetType:  pulumi.String("COST"),
 * 			LimitAmount: pulumi.String("100"),
 * 			LimitUnit:   pulumi.String("USD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cost = new Budget("cost", BudgetArgs.builder()
 *             .budgetType("COST")
 *             .limitAmount("100")
 *             .limitUnit("USD")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cost:
 *     type: aws:budgets:Budget
 *     properties:
 *       budgetType: COST
 *       limitAmount: '100'
 *       limitUnit: USD
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a budget with planned budget limits.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cost = new aws.budgets.Budget("cost", {plannedLimits: [
 *     {
 *         startTime: "2017-07-01_00:00",
 *         amount: "100",
 *         unit: "USD",
 *     },
 *     {
 *         startTime: "2017-08-01_00:00",
 *         amount: "200",
 *         unit: "USD",
 *     },
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cost = aws.budgets.Budget("cost", planned_limits=[
 *     {
 *         "start_time": "2017-07-01_00:00",
 *         "amount": "100",
 *         "unit": "USD",
 *     },
 *     {
 *         "start_time": "2017-08-01_00:00",
 *         "amount": "200",
 *         "unit": "USD",
 *     },
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cost = new Aws.Budgets.Budget("cost", new()
 *     {
 *         PlannedLimits = new[]
 *         {
 *             new Aws.Budgets.Inputs.BudgetPlannedLimitArgs
 *             {
 *                 StartTime = "2017-07-01_00:00",
 *                 Amount = "100",
 *                 Unit = "USD",
 *             },
 *             new Aws.Budgets.Inputs.BudgetPlannedLimitArgs
 *             {
 *                 StartTime = "2017-08-01_00:00",
 *                 Amount = "200",
 *                 Unit = "USD",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "cost", &budgets.BudgetArgs{
 * 			PlannedLimits: budgets.BudgetPlannedLimitArray{
 * 				&budgets.BudgetPlannedLimitArgs{
 * 					StartTime: pulumi.String("2017-07-01_00:00"),
 * 					Amount:    pulumi.String("100"),
 * 					Unit:      pulumi.String("USD"),
 * 				},
 * 				&budgets.BudgetPlannedLimitArgs{
 * 					StartTime: pulumi.String("2017-08-01_00:00"),
 * 					Amount:    pulumi.String("200"),
 * 					Unit:      pulumi.String("USD"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetPlannedLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cost = new Budget("cost", BudgetArgs.builder()
 *             .plannedLimits(
 *                 BudgetPlannedLimitArgs.builder()
 *                     .startTime("2017-07-01_00:00")
 *                     .amount("100")
 *                     .unit("USD")
 *                     .build(),
 *                 BudgetPlannedLimitArgs.builder()
 *                     .startTime("2017-08-01_00:00")
 *                     .amount("200")
 *                     .unit("USD")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cost:
 *     type: aws:budgets:Budget
 *     properties:
 *       plannedLimits:
 *         - startTime: 2017-07-01_00:00
 *           amount: '100'
 *           unit: USD
 *         - startTime: 2017-08-01_00:00
 *           amount: '200'
 *           unit: USD
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a budget for s3 with a limit of *3 GB* of storage.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const s3 = new aws.budgets.Budget("s3", {
 *     budgetType: "USAGE",
 *     limitAmount: "3",
 *     limitUnit: "GB",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * s3 = aws.budgets.Budget("s3",
 *     budget_type="USAGE",
 *     limit_amount="3",
 *     limit_unit="GB")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var s3 = new Aws.Budgets.Budget("s3", new()
 *     {
 *         BudgetType = "USAGE",
 *         LimitAmount = "3",
 *         LimitUnit = "GB",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "s3", &budgets.BudgetArgs{
 * 			BudgetType:  pulumi.String("USAGE"),
 * 			LimitAmount: pulumi.String("3"),
 * 			LimitUnit:   pulumi.String("GB"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new Budget("s3", BudgetArgs.builder()
 *             .budgetType("USAGE")
 *             .limitAmount("3")
 *             .limitUnit("GB")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   s3:
 *     type: aws:budgets:Budget
 *     properties:
 *       budgetType: USAGE
 *       limitAmount: '3'
 *       limitUnit: GB
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a Savings Plan Utilization Budget
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const savingsPlanUtilization = new aws.budgets.Budget("savings_plan_utilization", {
 *     budgetType: "SAVINGS_PLANS_UTILIZATION",
 *     limitAmount: "100.0",
 *     limitUnit: "PERCENTAGE",
 *     costTypes: {
 *         includeCredit: false,
 *         includeDiscount: false,
 *         includeOtherSubscription: false,
 *         includeRecurring: false,
 *         includeRefund: false,
 *         includeSubscription: true,
 *         includeSupport: false,
 *         includeTax: false,
 *         includeUpfront: false,
 *         useBlended: false,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * savings_plan_utilization = aws.budgets.Budget("savings_plan_utilization",
 *     budget_type="SAVINGS_PLANS_UTILIZATION",
 *     limit_amount="100.0",
 *     limit_unit="PERCENTAGE",
 *     cost_types={
 *         "include_credit": False,
 *         "include_discount": False,
 *         "include_other_subscription": False,
 *         "include_recurring": False,
 *         "include_refund": False,
 *         "include_subscription": True,
 *         "include_support": False,
 *         "include_tax": False,
 *         "include_upfront": False,
 *         "use_blended": False,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var savingsPlanUtilization = new Aws.Budgets.Budget("savings_plan_utilization", new()
 *     {
 *         BudgetType = "SAVINGS_PLANS_UTILIZATION",
 *         LimitAmount = "100.0",
 *         LimitUnit = "PERCENTAGE",
 *         CostTypes = new Aws.Budgets.Inputs.BudgetCostTypesArgs
 *         {
 *             IncludeCredit = false,
 *             IncludeDiscount = false,
 *             IncludeOtherSubscription = false,
 *             IncludeRecurring = false,
 *             IncludeRefund = false,
 *             IncludeSubscription = true,
 *             IncludeSupport = false,
 *             IncludeTax = false,
 *             IncludeUpfront = false,
 *             UseBlended = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "savings_plan_utilization", &budgets.BudgetArgs{
 * 			BudgetType:  pulumi.String("SAVINGS_PLANS_UTILIZATION"),
 * 			LimitAmount: pulumi.String("100.0"),
 * 			LimitUnit:   pulumi.String("PERCENTAGE"),
 * 			CostTypes: &budgets.BudgetCostTypesArgs{
 * 				IncludeCredit:            pulumi.Bool(false),
 * 				IncludeDiscount:          pulumi.Bool(false),
 * 				IncludeOtherSubscription: pulumi.Bool(false),
 * 				IncludeRecurring:         pulumi.Bool(false),
 * 				IncludeRefund:            pulumi.Bool(false),
 * 				IncludeSubscription:      pulumi.Bool(true),
 * 				IncludeSupport:           pulumi.Bool(false),
 * 				IncludeTax:               pulumi.Bool(false),
 * 				IncludeUpfront:           pulumi.Bool(false),
 * 				UseBlended:               pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var savingsPlanUtilization = new Budget("savingsPlanUtilization", BudgetArgs.builder()
 *             .budgetType("SAVINGS_PLANS_UTILIZATION")
 *             .limitAmount("100.0")
 *             .limitUnit("PERCENTAGE")
 *             .costTypes(BudgetCostTypesArgs.builder()
 *                 .includeCredit(false)
 *                 .includeDiscount(false)
 *                 .includeOtherSubscription(false)
 *                 .includeRecurring(false)
 *                 .includeRefund(false)
 *                 .includeSubscription(true)
 *                 .includeSupport(false)
 *                 .includeTax(false)
 *                 .includeUpfront(false)
 *                 .useBlended(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   savingsPlanUtilization:
 *     type: aws:budgets:Budget
 *     name: savings_plan_utilization
 *     properties:
 *       budgetType: SAVINGS_PLANS_UTILIZATION
 *       limitAmount: '100.0'
 *       limitUnit: PERCENTAGE
 *       costTypes:
 *         includeCredit: false
 *         includeDiscount: false
 *         includeOtherSubscription: false
 *         includeRecurring: false
 *         includeRefund: false
 *         includeSubscription: true
 *         includeSupport: false
 *         includeTax: false
 *         includeUpfront: false
 *         useBlended: false
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a RI Utilization Budget
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const riUtilization = new aws.budgets.Budget("ri_utilization", {
 *     budgetType: "RI_UTILIZATION",
 *     limitAmount: "100.0",
 *     limitUnit: "PERCENTAGE",
 *     costTypes: {
 *         includeCredit: false,
 *         includeDiscount: false,
 *         includeOtherSubscription: false,
 *         includeRecurring: false,
 *         includeRefund: false,
 *         includeSubscription: true,
 *         includeSupport: false,
 *         includeTax: false,
 *         includeUpfront: false,
 *         useBlended: false,
 *     },
 *     costFilters: [{
 *         name: "Service",
 *         values: ["Amazon Relational Database Service"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ri_utilization = aws.budgets.Budget("ri_utilization",
 *     budget_type="RI_UTILIZATION",
 *     limit_amount="100.0",
 *     limit_unit="PERCENTAGE",
 *     cost_types={
 *         "include_credit": False,
 *         "include_discount": False,
 *         "include_other_subscription": False,
 *         "include_recurring": False,
 *         "include_refund": False,
 *         "include_subscription": True,
 *         "include_support": False,
 *         "include_tax": False,
 *         "include_upfront": False,
 *         "use_blended": False,
 *     },
 *     cost_filters=[{
 *         "name": "Service",
 *         "values": ["Amazon Relational Database Service"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var riUtilization = new Aws.Budgets.Budget("ri_utilization", new()
 *     {
 *         BudgetType = "RI_UTILIZATION",
 *         LimitAmount = "100.0",
 *         LimitUnit = "PERCENTAGE",
 *         CostTypes = new Aws.Budgets.Inputs.BudgetCostTypesArgs
 *         {
 *             IncludeCredit = false,
 *             IncludeDiscount = false,
 *             IncludeOtherSubscription = false,
 *             IncludeRecurring = false,
 *             IncludeRefund = false,
 *             IncludeSubscription = true,
 *             IncludeSupport = false,
 *             IncludeTax = false,
 *             IncludeUpfront = false,
 *             UseBlended = false,
 *         },
 *         CostFilters = new[]
 *         {
 *             new Aws.Budgets.Inputs.BudgetCostFilterArgs
 *             {
 *                 Name = "Service",
 *                 Values = new[]
 *                 {
 *                     "Amazon Relational Database Service",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "ri_utilization", &budgets.BudgetArgs{
 * 			BudgetType:  pulumi.String("RI_UTILIZATION"),
 * 			LimitAmount: pulumi.String("100.0"),
 * 			LimitUnit:   pulumi.String("PERCENTAGE"),
 * 			CostTypes: &budgets.BudgetCostTypesArgs{
 * 				IncludeCredit:            pulumi.Bool(false),
 * 				IncludeDiscount:          pulumi.Bool(false),
 * 				IncludeOtherSubscription: pulumi.Bool(false),
 * 				IncludeRecurring:         pulumi.Bool(false),
 * 				IncludeRefund:            pulumi.Bool(false),
 * 				IncludeSubscription:      pulumi.Bool(true),
 * 				IncludeSupport:           pulumi.Bool(false),
 * 				IncludeTax:               pulumi.Bool(false),
 * 				IncludeUpfront:           pulumi.Bool(false),
 * 				UseBlended:               pulumi.Bool(false),
 * 			},
 * 			CostFilters: budgets.BudgetCostFilterArray{
 * 				&budgets.BudgetCostFilterArgs{
 * 					Name: pulumi.String("Service"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("Amazon Relational Database Service"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostTypesArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var riUtilization = new Budget("riUtilization", BudgetArgs.builder()
 *             .budgetType("RI_UTILIZATION")
 *             .limitAmount("100.0")
 *             .limitUnit("PERCENTAGE")
 *             .costTypes(BudgetCostTypesArgs.builder()
 *                 .includeCredit(false)
 *                 .includeDiscount(false)
 *                 .includeOtherSubscription(false)
 *                 .includeRecurring(false)
 *                 .includeRefund(false)
 *                 .includeSubscription(true)
 *                 .includeSupport(false)
 *                 .includeTax(false)
 *                 .includeUpfront(false)
 *                 .useBlended(false)
 *                 .build())
 *             .costFilters(BudgetCostFilterArgs.builder()
 *                 .name("Service")
 *                 .values("Amazon Relational Database Service")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   riUtilization:
 *     type: aws:budgets:Budget
 *     name: ri_utilization
 *     properties:
 *       budgetType: RI_UTILIZATION
 *       limitAmount: '100.0'
 *       limitUnit: PERCENTAGE
 *       costTypes:
 *         includeCredit: false
 *         includeDiscount: false
 *         includeOtherSubscription: false
 *         includeRecurring: false
 *         includeRefund: false
 *         includeSubscription: true
 *         includeSupport: false
 *         includeTax: false
 *         includeUpfront: false
 *         useBlended: false
 *       costFilters:
 *         - name: Service
 *           values:
 *             - Amazon Relational Database Service
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a Cost Filter using Resource Tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cost = new aws.budgets.Budget("cost", {costFilters: [{
 *     name: "TagKeyValue",
 *     values: ["TagKey$TagValue"],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cost = aws.budgets.Budget("cost", cost_filters=[{
 *     "name": "TagKeyValue",
 *     "values": ["TagKey$TagValue"],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cost = new Aws.Budgets.Budget("cost", new()
 *     {
 *         CostFilters = new[]
 *         {
 *             new Aws.Budgets.Inputs.BudgetCostFilterArgs
 *             {
 *                 Name = "TagKeyValue",
 *                 Values = new[]
 *                 {
 *                     "TagKey$TagValue",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "cost", &budgets.BudgetArgs{
 * 			CostFilters: budgets.BudgetCostFilterArray{
 * 				&budgets.BudgetCostFilterArgs{
 * 					Name: pulumi.String("TagKeyValue"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.String("TagKey$TagValue"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cost = new Budget("cost", BudgetArgs.builder()
 *             .costFilters(BudgetCostFilterArgs.builder()
 *                 .name("TagKeyValue")
 *                 .values("TagKey$TagValue")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cost:
 *     type: aws:budgets:Budget
 *     properties:
 *       costFilters:
 *         - name: TagKeyValue
 *           values:
 *             - TagKey$TagValue
 * ```
 * <!--End PulumiCodeChooser -->
 * Create a cost_filter using resource tags, obtaining the tag value from a variable
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const cost = new aws.budgets.Budget("cost", {costFilters: [{
 *     name: "TagKeyValue",
 *     values: [`TagKey${"$"}${tagValue}`],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * cost = aws.budgets.Budget("cost", cost_filters=[{
 *     "name": "TagKeyValue",
 *     "values": [f"TagKey{'$'}{tag_value}"],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cost = new Aws.Budgets.Budget("cost", new()
 *     {
 *         CostFilters = new[]
 *         {
 *             new Aws.Budgets.Inputs.BudgetCostFilterArgs
 *             {
 *                 Name = "TagKeyValue",
 *                 Values = new[]
 *                 {
 *                     $"TagKey{"$"}{tagValue}",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := budgets.NewBudget(ctx, "cost", &budgets.BudgetArgs{
 * 			CostFilters: budgets.BudgetCostFilterArray{
 * 				&budgets.BudgetCostFilterArgs{
 * 					Name: pulumi.String("TagKeyValue"),
 * 					Values: pulumi.StringArray{
 * 						pulumi.Sprintf("TagKey%v%v", "$", tagValue),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.budgets.Budget;
 * import com.pulumi.aws.budgets.BudgetArgs;
 * import com.pulumi.aws.budgets.inputs.BudgetCostFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cost = new Budget("cost", BudgetArgs.builder()
 *             .costFilters(BudgetCostFilterArgs.builder()
 *                 .name("TagKeyValue")
 *                 .values(String.format("TagKey%s%s", "$",tagValue))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   cost:
 *     type: aws:budgets:Budget
 *     properties:
 *       costFilters:
 *         - name: TagKeyValue
 *           values:
 *             - TagKey$${tagValue}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import budgets using `AccountID:BudgetName`. For example:
 * ```sh
 * $ pulumi import aws:budgets/budget:Budget myBudget 123456789012:myBudget
 * ```
 */
public class Budget internal constructor(
    override val javaResource: com.pulumi.aws.budgets.Budget,
) : KotlinCustomResource(javaResource, BudgetMapper) {
    /**
     * The ID of the target account for budget. Will use current user's account_id by default if omitted.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the budget.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Object containing AutoAdjustData which determines the budget amount for an auto-adjusting budget.
     */
    public val autoAdjustData: Output<BudgetAutoAdjustData>?
        get() = javaResource.autoAdjustData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> budgetAutoAdjustDataToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether this budget tracks monetary cost or usage.
     */
    public val budgetType: Output<String>
        get() = javaResource.budgetType().applyValue({ args0 -> args0 })

    /**
     * A list of CostFilter name/values pair to apply to budget.
     */
    public val costFilters: Output<List<BudgetCostFilter>>
        get() = javaResource.costFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    budgetCostFilterToKotlin(args0)
                })
            })
        })

    /**
     * Object containing CostTypes The types of cost included in a budget, such as tax and subscriptions.
     */
    public val costTypes: Output<BudgetCostTypes>
        get() = javaResource.costTypes().applyValue({ args0 ->
            args0.let({ args0 ->
                budgetCostTypesToKotlin(args0)
            })
        })

    /**
     * The amount of cost or usage being measured for a budget.
     */
    public val limitAmount: Output<String>
        get() = javaResource.limitAmount().applyValue({ args0 -> args0 })

    /**
     * The unit of measurement used for the budget forecast, actual spend, or budget threshold, such as dollars or GB. See [Spend](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/data-type-spend.html) documentation.
     */
    public val limitUnit: Output<String>
        get() = javaResource.limitUnit().applyValue({ args0 -> args0 })

    /**
     * The name of a budget. Unique within accounts.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The prefix of the name of a budget. Unique within accounts.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Object containing Budget Notifications. Can be used multiple times to define more than one budget notification.
     */
    public val notifications: Output<List<BudgetNotification>>?
        get() = javaResource.notifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        budgetNotificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Object containing Planned Budget Limits. Can be used multiple times to plan more than one budget limit. See [PlannedBudgetLimits](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_Budget.html#awscostmanagement-Type-budgets_Budget-PlannedBudgetLimits) documentation.
     */
    public val plannedLimits: Output<List<BudgetPlannedLimit>>?
        get() = javaResource.plannedLimits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        budgetPlannedLimitToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The end of the time period covered by the budget. There are no restrictions on the end date. Format: `2017-01-01_12:00`.
     */
    public val timePeriodEnd: Output<String>?
        get() = javaResource.timePeriodEnd().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start of the time period covered by the budget. If you don't specify a start date, AWS defaults to the start of your chosen time period. The start date must come before the end date. Format: `2017-01-01_12:00`.
     */
    public val timePeriodStart: Output<String>
        get() = javaResource.timePeriodStart().applyValue({ args0 -> args0 })

    /**
     * The length of time until a budget resets the actual and forecasted spend. Valid values: `MONTHLY`, `QUARTERLY`, `ANNUALLY`, and `DAILY`.
     * The following arguments are optional:
     */
    public val timeUnit: Output<String>
        get() = javaResource.timeUnit().applyValue({ args0 -> args0 })
}

public object BudgetMapper : ResourceMapper<Budget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.budgets.Budget::class == javaResource::class

    override fun map(javaResource: Resource): Budget = Budget(
        javaResource as
            com.pulumi.aws.budgets.Budget,
    )
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Budget].
 */
public suspend fun budget(name: String, block: suspend BudgetResourceBuilder.() -> Unit): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budget(name: String): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    return builder.build()
}
