@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin

import com.pulumi.aws.budgets.BudgetsFunctions.getBudgetPlain
import com.pulumi.aws.budgets.kotlin.inputs.GetBudgetPlainArgs
import com.pulumi.aws.budgets.kotlin.inputs.GetBudgetPlainArgsBuilder
import com.pulumi.aws.budgets.kotlin.outputs.GetBudgetResult
import com.pulumi.aws.budgets.kotlin.outputs.GetBudgetResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object BudgetsFunctions {
    /**
     * Data source for managing an AWS Web Services Budgets Budget.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.budgets.getBudget({
     *     name: testAwsBudgetsBudget.name,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.budgets.get_budget(name=test_aws_budgets_budget["name"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Budgets.GetBudget.Invoke(new()
     *     {
     *         Name = testAwsBudgetsBudget.Name,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/budgets"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := budgets.LookupBudget(ctx, &budgets.LookupBudgetArgs{
     * 			Name: testAwsBudgetsBudget.Name,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.budgets.BudgetsFunctions;
     * import com.pulumi.aws.budgets.inputs.GetBudgetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BudgetsFunctions.getBudget(GetBudgetArgs.builder()
     *             .name(testAwsBudgetsBudget.name())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:budgets:getBudget
     *       Arguments:
     *         name: ${testAwsBudgetsBudget.name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBudget.
     * @return A collection of values returned by getBudget.
     */
    public suspend fun getBudget(argument: GetBudgetPlainArgs): GetBudgetResult =
        toKotlin(getBudgetPlain(argument.toJava()).await())

    /**
     * @see [getBudget].
     * @param accountId The ID of the target account for budget. Will use current user's account_id by default if omitted.
     * @param name The name of a budget. Unique within accounts.
     * The following arguments are optional:
     * @param namePrefix The prefix of the name of a budget. Unique within accounts.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getBudget.
     */
    public suspend fun getBudget(
        accountId: String? = null,
        name: String,
        namePrefix: String? = null,
        tags: Map<String, String>? = null,
    ): GetBudgetResult {
        val argument = GetBudgetPlainArgs(
            accountId = accountId,
            name = name,
            namePrefix = namePrefix,
            tags = tags,
        )
        return toKotlin(getBudgetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBudget].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;budgets&#46;kotlin&#46;inputs&#46;GetBudgetPlainArgs].
     * @return A collection of values returned by getBudget.
     */
    public suspend fun getBudget(argument: suspend GetBudgetPlainArgsBuilder.() -> Unit): GetBudgetResult {
        val builder = GetBudgetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getBudgetPlain(builtArgument.toJava()).await())
    }
}
