@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.budgets.kotlin.inputs

import com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionThresholdType The type of threshold for a notification. Valid values are `PERCENTAGE` or `ABSOLUTE_VALUE`.
 * @property actionThresholdValue The threshold of a notification.
 */
public data class BudgetActionActionThresholdArgs(
    public val actionThresholdType: Output<String>,
    public val actionThresholdValue: Output<Double>,
) : ConvertibleToJava<com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs> {
    override fun toJava(): com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs =
        com.pulumi.aws.budgets.inputs.BudgetActionActionThresholdArgs.builder()
            .actionThresholdType(actionThresholdType.applyValue({ args0 -> args0 }))
            .actionThresholdValue(actionThresholdValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetActionActionThresholdArgs].
 */
@PulumiTagMarker
public class BudgetActionActionThresholdArgsBuilder internal constructor() {
    private var actionThresholdType: Output<String>? = null

    private var actionThresholdValue: Output<Double>? = null

    /**
     * @param value The type of threshold for a notification. Valid values are `PERCENTAGE` or `ABSOLUTE_VALUE`.
     */
    @JvmName("fkaqutbdvmaiujyn")
    public suspend fun actionThresholdType(`value`: Output<String>) {
        this.actionThresholdType = value
    }

    /**
     * @param value The threshold of a notification.
     */
    @JvmName("xamnipoxmgpyyrjf")
    public suspend fun actionThresholdValue(`value`: Output<Double>) {
        this.actionThresholdValue = value
    }

    /**
     * @param value The type of threshold for a notification. Valid values are `PERCENTAGE` or `ABSOLUTE_VALUE`.
     */
    @JvmName("ucqlwotuqjmgeptw")
    public suspend fun actionThresholdType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionThresholdType = mapped
    }

    /**
     * @param value The threshold of a notification.
     */
    @JvmName("hpqvxqujiwjitpvx")
    public suspend fun actionThresholdValue(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionThresholdValue = mapped
    }

    internal fun build(): BudgetActionActionThresholdArgs = BudgetActionActionThresholdArgs(
        actionThresholdType = actionThresholdType ?: throw PulumiNullFieldException("actionThresholdType"),
        actionThresholdValue = actionThresholdValue ?: throw
            PulumiNullFieldException("actionThresholdValue"),
    )
}
